<?php 
require_once("header.php");

// Handle delete request
if (isset($_GET['del']) && is_numeric($_GET['del'])) {
    $id = (int) $_GET['del'];
    $stmt = $pdo->prepare("DELETE FROM packages WHERE id = ?");
    $stmt->execute([$id]);
    echo "<span style='color:red'>Successfully deleted<br><meta http-equiv='refresh' content='2;url=list_parcel.php'/></span>";
}
?>

<div class="container" align="center" style="margin-top:20px;">
  <div class="construction-section-title">
    <h2>PARCEL</h2>
  </div>

  <div class="main-panel">
    <div class="content bg-light">
      <div class="page-inner">
        <div class="mt-2 mb-4">
          <h1 class="title1 text-dark">Parcel List</h1>
        </div>

        <div class="card-header">
          <div class="row">
            <div class="col-6">
              <div class="card-body">
                <div class="">
                  <table class="">
                    <thead>
                      <tr>
                        <th><a class="btn btn-primary btn-sm float-right" href="add_parcel.php"><span class="fa fa-user-plus">&nbsp;New Parcel</span></a></th>
                      </tr>
                    </thead>
                  </table>
                </div>
              </div>
            </div>
          </div>
        </div>

        <?php
        $stmt = $pdo->query("SELECT * FROM packages ORDER BY id ASC");
        $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);
        ?>

        <input type='text' id='myInput' onkeyup='myFunction()' placeholder='Search for names..' class='form-control mb-3'>

        <div class='table-responsive'>
          <table id='myTable' class='table table-hover text-dark'>
            <thead>
              <tr>
                <th>S/N</th>
                <th>COMPANY NAME</th>
                <th>COMPANY LOCATION</th>
                <th>COMPANY PHONE</th>
                <th>SHIPPING COST</th>
                <th>SUB-COST</th>
                <th>TOTAL COST</th>
                <th>DELIVERY STATUS</th>
                <th>CONSIGNMENT STATUS</th>
                <th>BILLING NAME</th>
                <th>BILLING COST</th>
                <th>CURRENT LOCATION</th>
                <th>FINAL DESTINATION</th>
                <th>CONSIGNMENT QUANTITY</th>
                <th>ARRIVAL DATE</th>
                <th>DEPARTURE DATE</th>
                <th>ARRIVAL TIME</th>
                <th>PARCEL NAME</th>
                <th>PARCEL DETAILS</th>
                <th>SHIPMENT TO</th>
                <th>SHIPMENT FROM</th>
                <th>TRACKING CODE</th>
                <th>RECEIVER NAME</th>
                <th>RECEIVER EMAIL</th>
                <th>RECEIVER ADDRESS</th>
                <th>RECEIVER PHONE</th>
                <th>RECEIVER LOCATION</th>
                <th>SENDER NAME</th>
                <th>SENDER ADDRESS</th>
                <th>SENDER PHONE</th>
                <th>SENDER LOCATION</th>
                <th>PRINT RECEIPT</th>
                <th>ACTION</th>
              </tr>
            </thead>
            <tbody>
              <?php foreach ($rows as $row): ?>
                <tr>
                  <td><?= $row['id'] ?></td>
                  <td><?= htmlspecialchars($row['comp_name']) ?></td>
                  <td><?= htmlspecialchars($row['comp_location']) ?></td>
                  <td><?= htmlspecialchars($row['comp_phone']) ?></td>
                  <td><?= htmlspecialchars($row['ship_cost']) ?></td>
                  <td><?= htmlspecialchars($row['sub_cost']) ?></td>
                  <td><?= htmlspecialchars($row['total_cost']) ?></td>
                  <td><?= htmlspecialchars($row['delivery_status']) ?></td>
                  <td><?= htmlspecialchars($row['consignment_status']) ?></td>
                  <td><?= htmlspecialchars($row['billing_name']) ?></td>
                  <td><?= htmlspecialchars($row['billing_cost']) ?></td>
                  <td><?= htmlspecialchars($row['current_location']) ?></td>
                  <td><?= htmlspecialchars($row['final_destination']) ?></td>
                  <td><?= htmlspecialchars($row['consignment_quantity']) ?></td>
                  <td><?= htmlspecialchars($row['arrival_date']) ?></td>
                  <td><?= htmlspecialchars($row['departure_date']) ?></td>
                  <td><?= htmlspecialchars($row['arrival_time']) ?></td>
                  <td><?= htmlspecialchars($row['parcel_name']) ?></td>
                  <td><?= htmlspecialchars($row['parcel_details']) ?></td>
                  <td><?= htmlspecialchars($row['shipment_to']) ?></td>
                  <td><?= htmlspecialchars($row['shipment_from']) ?></td>
                  <td><?= htmlspecialchars($row['tracking_code']) ?></td>
                  <td><?= htmlspecialchars($row['recv_name']) ?></td>
                  <td><?= htmlspecialchars($row['recv_email']) ?></td>
                  <td><?= htmlspecialchars($row['recv_address']) ?></td>
                  <td><?= htmlspecialchars($row['recv_phone']) ?></td>
                  <td><?= htmlspecialchars($row['recv_location']) ?></td>
                  <td><?= htmlspecialchars($row['sdr_name']) ?></td>
                  <td><?= htmlspecialchars($row['sdr_address']) ?></td>
                  <td><?= htmlspecialchars($row['sdr_phone']) ?></td>
                  <td><?= htmlspecialchars($row['sdr_location']) ?></td>
                  <td>
                    <a href='print-invoice/invoice-print.php?id=<?= $row['id'] ?>' target='_blank'>
                      <img style='width: 205px; height: 70px;' src='../img/barcode.png'><br>
                      <?= htmlspecialchars($row['tracking_code']) ?>
                    </a>
                  </td>
                  <td>
                    <a class='btn btn-success' href='location_parcel.php?id=<?= $row['id'] ?>'>CHANGE LOCATION</a>
                    <!--<a class='btn btn-primary' href='view_parcel.php?id=<?= $row['id'] ?>'>EDIT PARCEL</a>-->
                    <a class='btn btn-danger' href='list_parcel.php?del=<?= $row['id'] ?>'>DELETE PARCEL</a>
                  </td>
                </tr>
              <?php endforeach; ?>
            </tbody>
          </table>
        </div>
      </div>
    </div>
  </div>
</div>

<?php require("footer.php"); ?>
