<?php
// Enable error reporting
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require("header.php");

$errorMessage = "";
$successMessage = "";

// Handle password change form submission
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['change_password'])) {
    $currentPassword = trim($_POST['current_password']);
    $newPassword = trim($_POST['new_password']);
    $confirmPassword = trim($_POST['confirm_password']);
    $firstName = trim($_POST['firstname']);
    $username = trim($_POST['username']);

    if (!empty($currentPassword) && !empty($newPassword) && !empty($confirmPassword) && !empty($firstName) && !empty($username)) {
        // Fetch current admin record
        $stmt = $pdo->prepare("SELECT * FROM logins WHERE id = :id");
        $stmt->execute(['id' => $_SESSION['SESS_ADMINUSERID']]);
        $admin = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($admin && password_verify($currentPassword, $admin['password'])) {
            if ($newPassword === $confirmPassword) {
                $hashedPassword = password_hash($newPassword, PASSWORD_BCRYPT);

                // Update user info
                $updateStmt = $pdo->prepare("UPDATE logins SET password = :password, firstname = :firstname, username = :username WHERE id = :id");
                $updateStmt->execute([
                    'password' => $hashedPassword,
                    'firstname' => $firstName,
                    'username' => $username,
                    'id' => $_SESSION['SESS_ADMINUSERID']
                ]);

                // Update session data
                $_SESSION['SESS_ADMINFIRSTNAME'] = $firstName;
                $_SESSION['SESS_ADMINUSERNAME'] = $username;

                $successMessage = "Password and profile updated successfully!";
            } else {
                $errorMessage = "New password and confirm password do not match!";
            }
        } else {
            $errorMessage = "Incorrect current password!";
        }
    } else {
        $errorMessage = "All fields are required!";
    }
}
?>

<style>
    label {
        color: white;
        background-color: black;
        padding: 5px;
        display: inline-block;
    }
</style>


<div class="main-panel">
    <div class="content bg-light">
        <div class="page-inner">
            <div class="mb-5 row">
                <div class="col-md-12">
                    <center>
                        <div class="page-breadcrumb">
                            <div class="row">
                                <div class="col-12 d-flex no-block align-items-center">
                                    <h4 class="page-title">ADMIN PASSWORD</h4>
                                    <div class="ml-auto text-right">
                                        <nav aria-label="breadcrumb">
                                            <ol class="breadcrumb">
                                                <li class="breadcrumb-item"><a href="index.php">Home</a></li>
                                                <li class="breadcrumb-item active">Manage Password</li>
                                            </ol>
                                        </nav>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </center>

                    <?php if (!empty($errorMessage)) : ?>
                        <div style="color: red;"><?php echo $errorMessage; ?></div>
                    <?php endif; ?>

                    <?php if (!empty($successMessage)) : ?>
                        <div style="color: green;"><?php echo $successMessage; ?></div>
                    <?php endif; ?>

                    <h4>Enter your details correctly and click "Change Password" below</h4>

                    <form method="POST" action="" class="form">
                        <div class="card-body">
                            <div class="form-group">
                                <label style="color: red;" for="current_password">Current Password</label>
                                <input type="password" name="current_password" autocomplete="off" placeholder="********" required class='form-control bg-light text-dark'>
                            </div>

                            <div class="form-group">
                                <label style="color: red;" for="new_password">New Password</label>
                                <input type="password" name="new_password" autocomplete="off" placeholder="********" required class='form-control bg-light text-dark'>
                            </div>

                            <div class="form-group">
                                <label style="color: red;" for="confirm_password">Confirm Password</label>
                                <input type="password" name="confirm_password" autocomplete="off" placeholder="********" required class='form-control bg-light text-dark'>
                            </div>

                            <div class="form-group">
                                <label style="color: red;" for="username">Username</label>
                                <input type="text" name="username" value="<?php echo htmlspecialchars($_SESSION['SESS_ADMINUSERNAME']); ?>" required class='form-control bg-light text-dark'>
                            </div>

                           <?php
// Re-fetch firstname from DB using the admin ID from session
$admin_id = $_SESSION['SESS_ADMINUSERID'];
$stmt = $pdo->prepare("SELECT firstname FROM logins WHERE id = ?");
$stmt->execute([$admin_id]);
$admin = $stmt->fetch(PDO::FETCH_ASSOC);
$current_firstname = $admin['firstname'] ?? '';
?>

<div class="form-group">
    <label style="font-color: red" >Full Name</label>
    <input type="text" name="firstname" value="<?php echo htmlspecialchars($current_firstname); ?>" required class='form-control bg-light text-dark'>
</div>

                        </div>

                        <div class="card-footer">
                            <button type="submit" name="change_password" class="btn btn-primary">CHANGE PASSWORD</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<?php require("footer.php"); ?>
