<?php 
session_start();

if (!isset($_SESSION['SESS_ADMINLOGGEDIN'])) {
    header("Location: ../admin/adminlogin.php");
    exit();
}

require_once("header.php");
require_once("../config.php");

// Fetch settings from the database using PDO
$stmt = $pdo->query("SELECT * FROM settings ORDER BY id DESC LIMIT 1");
$row = $stmt->fetch(PDO::FETCH_ASSOC);

if ($row) {
    $cphone  = $row['phone'];
    $curl    = $row['url'];
    $cdomain = $row['domain'];
    $cname   = $row['domain_name'];
    $cpass   = $row['password'];
    $cemail  = $row['email2'];
    $cright  = $row['copyright'];
    $chost   = $row['contact_email'];
    $cport   = $row['service1'];
    $title   = $row['title'];
    $webmail   = $row['webmail'];
}
?>

<div class="main-panel">
    <div class="content bg-light">
        <div class="page-inner">
            <div class="mt-2 mb-4">
                <h1 class="title1 text-dark">WEBMAIL INFORMATION</h1>
            </div>

            <div class="row mb-5">
                <div class="col-md-12">
                    <div class="card shadow p-4 bg-light">
                        <form class="reservation-form mb-0 bg-silver-deep p-4" method="post">
                            
                            <label class="form-label text-dark fw-bold">WEBMAIL LOGIN</label>
                            <input type="text" class="form-control bg-light text-dark mb-3" value="<?php echo htmlspecialchars($cemail); ?>" readonly>

                           
                            
                            <label class="form-label text-dark fw-bold">WEBMAIL PASSWORD</label>
                            <input type="text" class="form-control bg-light text-dark mb-3" value="<?php echo htmlspecialchars($cpass); ?>" readonly>
                            
                            <div class="text-center">
                                <a href="<?php echo htmlspecialchars($webmail); ?>" target="_blank" class="btn btn-accent">GO TO WEBMAIL</a>
                            </div>
                            
                        </form>
                    </div>
                </div>
            </div>

        </div>
    </div>
</div>

<?php require_once("footer.php"); ?>
