<?php
session_start();
require_once '../../config.php'; // Ensure this is included BEFORE using $config_basedir

if (empty($_SESSION['SESS_LOGGEDIN'])) {
    header("Location: " . $config_basedir . "../../tracking.php");
    exit();
}
?>

<!DOCTYPE html>
<html>
<head>
    <title><?php echo htmlspecialchars($title); ?></title>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
    <meta name="description" content="Courier Deprixa V2.5 "/>
    <meta name="keywords" content="Courier DEPRIXA-Integral Web System" />
    <meta name="author" content="Jaomweb">
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
    <link href="css/bootstrap.min.css" rel="stylesheet" type="text/css" />
    <link href="https://maxcdn.bootstrapcdn.com/font-awesome/4.3.0/css/font-awesome.min.css" rel="stylesheet" type="text/css" />
    <link href="https://code.ionicframework.com/ionicons/2.0.1/css/ionicons.min.css" rel="stylesheet" type="text/css" />
    <link href="css/print-invoice.min.css" rel="stylesheet" type="text/css" />
    <!--[if lt IE 9]>
        <script src="https://oss.maxcdn.com/html5shiv/3.7.2/html5shiv.min.js"></script>
        <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
    <![endif]-->
    <script src="barcode.js"></script>
</head>
<body onload="window.print();">
<div class="wrapper">
<section class="invoice">
    <div class="row">
        <div class="col-xs-12">
            <h2 class="page-header">
                <span><img src="<?php echo $url ?>img/LOGO.png"></span>
<?php
$id = isset($_GET['id']) ? intval($_GET['id']) : 0;
if (!$id) {
    echo "<p>Invalid package ID.</p>";
    exit();
}

try {
    $stmt = $pdo->prepare("SELECT * FROM packages WHERE id = :id");
    $stmt->execute([':id' => $id]);
    $ordrow = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$ordrow) {
        echo "<p>Package not found.</p>";
        exit();
    }

    echo "<small class='pull-right'>" . htmlspecialchars($ordrow['arrival_date']) . " ||  " . htmlspecialchars($ordrow['arrival_time']) . "</small>";
    echo "</h2></div></div>";
    echo "<div class='row invoice-info'>
        <div class='col-sm-4 invoice-col'>
            From
            <address>
                <h4><strong>" . htmlspecialchars($ordrow['sdr_name']) . "</strong></h4><br>
                <b>Phone:</b>" . htmlspecialchars($ordrow['sdr_phone']) . "<br/>
                <b>Address:</b>" . htmlspecialchars($ordrow['sdr_address']) . "<br/>
                <b>Origin Office:</b>" . htmlspecialchars($ordrow['shipment_from']) . "
            </address>
        </div>
        <div class='col-sm-4 invoice-col'>
            To
            <address>
                <h4><strong>" . htmlspecialchars($ordrow['recv_name']) . "</strong></h4><br>
                <b>Phone:</b>" . htmlspecialchars($ordrow['recv_phone']) . "<br/>
                <b>Address:</b>" . htmlspecialchars($ordrow['recv_address']) . "<br/>
                <b>Destination Office:</b>" . htmlspecialchars($ordrow['shipment_to']) . "
            </address>
        </div>
        <div class='col-sm-4 invoice-col'>
            <table><tr><td><center>
            <img src='barcode.php?text=" . urlencode($ordrow['tracking_code']) . "' alt='barcode' /><br>
            " . htmlspecialchars($ordrow['tracking_code']) . "<br></center></td></tr></table>
            <br>
            <b>Parcel Name:</b>&nbsp;&nbsp;" . htmlspecialchars($ordrow['parcel_name']) . "<br/>
            <b>Weight (Qty):</b>&nbsp;&nbsp;" . htmlspecialchars($ordrow['consignment_quantity']) . "<br/>
            <b>Tracking Code:</b>&nbsp;&nbsp;" . htmlspecialchars($ordrow['tracking_code']) . "<br/>
            <b>Shipping Cost:</b><small class='label label-success'>&#36;" . htmlspecialchars($ordrow['ship_cost']) . "</small><br/>
            <b>Sub Cost:</b> <small class='label label-danger'><i class='fa fa-money'></i>&nbsp;&nbsp;&#36;" . htmlspecialchars($ordrow['sub_cost']) . "</small><br/>
            <b>Total Cost:</b> &nbsp;&#36;" . htmlspecialchars($ordrow['total_cost']) . "<br/>
        </div>
    </div>";

    echo "<div class='row'>
        <div class='col-xs-12 table-responsive'>
            <table class='table table-striped'>
                <thead>
                    <tr>
                        <th>Qty</th>
                        <th>Tracking Code</th>
                        <th>Ship Cost</th>
                        <th>Sub Total</th>
                        <th>Total Cost</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td>" . htmlspecialchars($ordrow['consignment_quantity']) . "</td>
                        <td>" . htmlspecialchars($ordrow['tracking_code']) . "</td>
                        <td><small class='label label-success'>&#36;" . htmlspecialchars($ordrow['ship_cost']) . "</small></td>
                        <td><small class='label label-danger'><i class='fa fa-money'></i>&nbsp;&nbsp;&#36;" . htmlspecialchars($ordrow['sub_cost']) . "</small></td>
                        <td>&nbsp;&#36;" . htmlspecialchars($ordrow['total_cost']) . "</td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>
    <br><br>
    <div class='row'>
        <div class='col-xs-6'>
            <p class='lead'>Payment Methods:</p>
            <img src='securepayment.png' alt='Methods payments' />
            <p class='text-muted well well-sm no-shadow' style='margin-top: 10px;'>
                For your convenience we have DEPRIXA several payment reliable, fast, secure.
            </p>
        </div>
    </div>";
} catch (PDOException $e) {
    echo "<p>Error fetching package: " . htmlspecialchars($e->getMessage()) . "</p>";
}
?>
</section>
</div>
<script src="js/app.min.js" type="text/javascript"></script>
</body>
</html>
