<?php
session_start();
date_default_timezone_set('Africa/Lagos');

require_once '../config.php'; // Database connection



   // Fetch settings from database
    $stmt = $pdo->query("SELECT * FROM settings ORDER BY id DESC LIMIT 1");
    $settings = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if ($settings) {
        $title = $settings['title'];
        $id = $settings['id'];
        $welc_head = $settings['welc_head'];
        $welc_msg = $settings['welc_msg'];
        $url = $settings['url'];
        $ceo = $settings['ceo'];
        $domain = $settings['domain'];
        $domain_name = $settings['domain_name'];
        $phone = $settings['phone'];
        $phone2 = $settings['phone2'];
        $country = $settings['country'];
        $state = $settings['state'];
        $city = $settings['city'];
        $address = $settings['address'];
        $email = $settings['email'];
        $email2 = $settings['email2'];
        $copyright = $settings['copyright'];
        $contact_email = $settings['contact_email'];
        $developa = $settings['developa'];
        $tellawctb = $settings['tellawctb'];
        $tellawtdsu = $settings['tellawtdsu'];
        $BTCLOGO = $settings['BTCLOGO'];
        $USDTLOGO = $settings['USDTLOGO'];
        $LOGO = $settings['LOGO'];
        $favicon = $settings['favicon'];
        $password = $settings['password'];
        $sell_rate = $settings['sell_rate'];
        $buy_rate = $settings['buy_rate'];

        // Currency Exchange Rates
        $GHS = $settings['GHS'];
        $EUR = $settings['EUR'];
        $NGN = $settings['NGN'];
        $CAD = $settings['CAD'];
        $GBP = $settings['GBP'];
        $ZAR = $settings['ZAR'];
        $USD = $settings['USD'];
        $AUD = $settings['AUD'];
        $JPY = $settings['JPY'];
        $CNY = $settings['CNY'];
        $PHP = $settings['PHP'];
        $UAE = $settings['UAE'];
        $BRL = $settings['BRL'];
        $ARS = $settings['ARS'];

        // Statistics
        $reg_clients = $settings['reg_clients'];
        $btc_sold = $settings['btc_sold'];
        $btc_bought = $settings['btc_bought'];

        // News & About Section
        $news_head = $settings['news_head'];
        $news_msg = $settings['news_msg'];
        $about_head = $settings['about_head'];
        $about_msg = $settings['about_msg'];

        // Services
        $service1 = $settings['service1'];
        $service2 = $settings['service2'];
        $service3 = $settings['service3'];
        $whatsapp = $settings['whatsapp'];
    } else {
        die("No settings found in the database.");
    }


// Fetch settings from database


    // $stmt = $pdo->query("SELECT * FROM settings ORDER BY id DESC LIMIT 1");
    // $settings = $stmt->fetch(PDO::FETCH_ASSOC);

    // if ($settings) {
    //     $title = $settings['title'];
    //     $domain_name = $settings['domain_name'];
    //     $LOGO = $settings['LOGO'];
    //     $favicon = $settings['favicon'];
    //     $copyright = $settings['copyright'];
    // } else {
    //     die("No settings found in the database.");
    // }

// Redirect if already logged in
if (isset($_SESSION['SESS_ADMINLOGGEDIN']) && $_SESSION['SESS_ADMINLOGGEDIN'] === true) {
    header("Location: dashboard.php");
    exit();
}

$errorMessage = "";




// Process login form
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['login'])) {
    $username = trim($_POST['username']);
    $password = trim($_POST['password']);

    if (!empty($username) && !empty($password)) {
        // Prepare and execute query
        $stmt = $pdo->prepare("SELECT * FROM logins WHERE username = :username");
        $stmt->execute(['username' => $username]);
        $admin = $stmt->fetch(PDO::FETCH_ASSOC);

        // Check if user exists and password matches
        if ($admin && password_verify($password, $admin['password'])) {
            // Check if IP is 0 (allowed access)
            if ($admin['ip'] == 0) {
                // Set session variables
                $_SESSION['SESS_ADMINLOGGEDIN']  = true;
                $_SESSION['SESS_ADMINUSERNAME']  = $admin['username'];
                $_SESSION['SESS_ADMINFULLNAME']  = $admin['fullname'];
                $_SESSION['SESS_ADMINUSERID']    = $admin['id'];
                $_SESSION['SESS_ADMINUSERIP']    = $admin['ip'];
                $_SESSION['SESS_ADMINHASH']      = $admin['password']; // (optional - use with caution)

                // Redirect to admin dashboard
                header("Location: dashboard.php");
                exit();
            } else {
                $errorMessage = "No permission is allowed!";
            }
        } else {
            $errorMessage = "Incorrect username or password!";
        }
    } else {
        $errorMessage = "Both username and password are required!";
    }
}



?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= htmlspecialchars($domain_name) ?> | Admin Login</title>

    <!-- Favicon -->
    <link rel="icon" href="img/<?= htmlspecialchars($favicon) ?>" type="image/png">

    <!-- Bootstrap & CSS -->
    <link rel="stylesheet" href="temp/css/bootstrap.min.css">
    <link rel="stylesheet" href="temp/css/style.css">
</head>
<body class="h-100 bg-soft-primary">
    <section class="auth">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-md-6">
                    <div class="text-center">
                        <a href="/"><img src="../img/LOGO.png" alt="Logo" class="mb-3 img-fluid auth__logo"></a>
                    </div>
                    
                    <div class="card login-page border-1 shadow rounded">
                        <div class="card-body">
                            <h4 class="text-center">Admin Login</h4>

                            <?php if (!empty($errorMessage)): ?>
                                <div class="alert alert-danger text-center">
                                    <?= htmlspecialchars($errorMessage) ?>
                                </div>
                            <?php endif; ?>

                            <form action="" method="POST">
                                <div class="form-group">
                                    <label>Username <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control" name="username" placeholder="Enter username" required>
                                </div>

                                <div class="form-group">
                                    <label>Password <span class="text-danger">*</span></label>
                                    <input type="password" class="form-control" name="password" placeholder="Enter password" required>
                                </div>

                                <div class="text-center">
                                    <button type="submit" name="login" class="btn btn-primary btn-block">Login</button>
                                </div>

                                <p class="text-center mt-3">
                                    <a href="forgot_password.php">Forgot password?</a>
                                </p>
                            </form>

                            <!--<p class="text-center mt-3">-->
                            <!--    <small><= htmlspecialchars($copyright); ?></small>-->
                            <!--</p>-->
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Scripts -->
    <script src="temp/js/jquery-3.5.1.min.js"></script>
    <script src="temp/js/bootstrap.bundle.min.js"></script>
</body>
</html>
